/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.mixin.fabric.client;

import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.impl.TooltipEventColorContextImpl;
import dev.architectury.impl.TooltipEventPositionContextImpl;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_332.class})
public abstract class MixinGuiGraphics {
    @Unique
    private static ThreadLocal<TooltipEventPositionContextImpl> tooltipPositionContext = ThreadLocal.withInitial(TooltipEventPositionContextImpl::new);
    @Unique
    private static ThreadLocal<TooltipEventColorContextImpl> tooltipColorContext = ThreadLocal.withInitial(TooltipEventColorContextImpl::new);

    @Inject(method={"renderTooltip(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"}, at={@At(value="HEAD")})
    private void preRenderTooltipItem(class_327 font, class_1799 stack, int x, int y, CallbackInfo ci) {
        ClientTooltipEvent.additionalContexts().setItem(stack);
    }

    @Inject(method={"renderTooltip(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"}, at={@At(value="RETURN")})
    private void postRenderTooltipItem(class_327 font, class_1799 stack, int x, int y, CallbackInfo ci) {
        ClientTooltipEvent.additionalContexts().setItem(null);
    }

    @Inject(method={"renderTooltipInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTooltip(class_327 font, List<? extends class_5684> list, int x, int y, class_8000 positioner, CallbackInfo ci) {
        if (!list.isEmpty()) {
            TooltipEventColorContextImpl colorContext = tooltipColorContext.get();
            colorContext.reset();
            TooltipEventPositionContextImpl positionContext = tooltipPositionContext.get();
            positionContext.reset(x, y);
            if (ClientTooltipEvent.RENDER_PRE.invoker().renderTooltip((class_332)this, list, x, y).isFalse()) {
                ci.cancel();
            } else {
                ClientTooltipEvent.RENDER_MODIFY_POSITION.invoker().renderTooltip((class_332)this, positionContext);
            }
        }
    }

    @ModifyVariable(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private int modifyTooltipX(int original) {
        return tooltipPositionContext.get().getTooltipX();
    }

    @ModifyVariable(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private int modifyTooltipY(int original) {
        return tooltipPositionContext.get().getTooltipY();
    }
}

