/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public final class JadeFabricUtils {
    private JadeFabricUtils() {
    }

    public static List<ViewGroup<class_2487>> fromFluidStorage(Storage<FluidVariant> storage) {
        ArrayList list = Lists.newArrayList();
        long emptyCapacity = 0L;
        for (StorageView view : storage) {
            long capacity = view.getCapacity();
            if (capacity <= 0L) continue;
            if (view.isResourceBlank() || view.getAmount() <= 0L) {
                emptyCapacity = LongMath.saturatedAdd((long)emptyCapacity, (long)capacity);
                continue;
            }
            list.add(FluidView.writeDefault(JadeFluidObject.of(((FluidVariant)view.getResource()).getFluid(), view.getAmount(), ((FluidVariant)view.getResource()).getNbt()), capacity));
        }
        if (list.isEmpty() && emptyCapacity > 0L) {
            list.add(FluidView.writeDefault(JadeFluidObject.empty(), emptyCapacity));
        }
        if (!list.isEmpty()) {
            return List.of(new ViewGroup(list));
        }
        return List.of();
    }

    public static ViewGroup<class_1799> fromItemStorage(Storage<ItemVariant> storage, int maxSize, int startIndex) {
        return ItemView.compacted(Streams.stream((Iterator)storage.iterator()).skip(startIndex).limit((long)maxSize * 3L).map($ -> ((ItemVariant)$.getResource()).toStack((int)class_3532.method_15363((float)$.getAmount(), (float)0.0f, (float)2.1474836E9f))), maxSize);
    }
}

