/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.text2speech.Narrator;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.RayTracing;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.util.ClientProxy;

public class WailaTickHandler {
    private static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static Narrator narrator;
    private static String lastNarration;
    public TooltipRenderer tooltipRenderer = null;
    public ProgressTracker progressTracker = new ProgressTracker();

    private static Narrator getNarrator() {
        return narrator == null ? (narrator = Narrator.getNarrator()) : narrator;
    }

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    public static void narrate(ITooltip tooltip, boolean dedupe) {
        if (!WailaTickHandler.getNarrator().active() || tooltip.isEmpty()) {
            return;
        }
        String narration = tooltip.getMessage();
        if (dedupe && narration.equals(lastNarration)) {
            return;
        }
        Narrator narrator = WailaTickHandler.getNarrator();
        narrator.say(narration, true);
        lastNarration = narration;
    }

    public void tickClient() {
        class_3965 blockTarget;
        this.progressTracker.tick();
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.tooltipRenderer = null;
            return;
        }
        class_310 client = class_310.method_1551();
        if (!ClientProxy.shouldShowWithOverlay(client, client.field_1755)) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world == null || player == null) {
            this.tooltipRenderer = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        class_239 target = RayTracing.INSTANCE.getTarget();
        Tooltip tooltip = new Tooltip();
        if (target == null) {
            this.tooltipRenderer = null;
            return;
        }
        Accessor<class_3966> accessor = null;
        if (target instanceof class_3965 && (blockTarget = (class_3965)target).method_17783() != class_239.class_240.field_1333) {
            class_2680 state = world.method_8320(blockTarget.method_17777());
            class_2586 tileEntity = world.method_8321(blockTarget.method_17777());
            accessor = WailaClientRegistration.INSTANCE.blockAccessor().blockState(state).blockEntity(tileEntity).hit(blockTarget).build();
        } else if (target instanceof class_3966) {
            class_3966 entityTarget = (class_3966)target;
            accessor = WailaClientRegistration.INSTANCE.entityAccessor().hit(entityTarget).entity(entityTarget.method_17782()).build();
        } else if (client.field_1755 instanceof BaseOptionsScreen) {
            accessor = WailaClientRegistration.INSTANCE.blockAccessor().blockState(class_2246.field_10219.method_9564()).hit(new class_3965(player.method_19538(), class_2350.field_11036, player.method_24515(), false)).build();
        }
        EntityAccessor originalAccessor = accessor;
        for (JadeRayTraceCallback callback : WailaClientRegistration.INSTANCE.rayTraceCallback.callbacks()) {
            accessor = callback.onRayTrace(target, accessor, originalAccessor);
        }
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.tooltipRenderer = null;
            return;
        }
        Accessor.ClientHandler<Accessor<?>> handler = WailaClientRegistration.INSTANCE.getAccessorHandler(accessor.getAccessorType());
        if (!handler.shouldDisplay(accessor)) {
            this.tooltipRenderer = null;
            return;
        }
        if (accessor.isServerConnected()) {
            boolean request = handler.shouldRequestData(accessor);
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (request) {
                    handler.requestData(accessor);
                }
            }
            if (request && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            handler.gatherComponents(accessor, $ -> {
                if (Math.abs(WailaCommonRegistration.INSTANCE.priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            handler.gatherComponents(accessor, $ -> tooltip);
        }
        for (JadeTooltipCollectedCallback callback : WailaClientRegistration.INSTANCE.tooltipCollectedCallback.callbacks()) {
            callback.onTooltipCollected(tooltip, accessor);
        }
        this.tooltipRenderer = new TooltipRenderer(tooltip, true);
    }

    static {
        lastNarration = "";
    }
}

