/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import net.minecraft.class_1041;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_768;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.ITooltipRenderer;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.RayTracing;

public class TooltipRenderer
implements ITooltipRenderer {
    private final Tooltip tooltip;
    private final boolean showIcon;
    private class_241 totalSize;
    private IElement icon;
    private float[] padding = new float[]{4.0f, 3.0f, 1.0f, 4.0f};

    public TooltipRenderer(Tooltip tooltip, boolean showIcon) {
        this.showIcon = showIcon;
        this.tooltip = tooltip;
        if (showIcon) {
            this.icon = RayTracing.INSTANCE.getIcon();
        }
        this.recalculateSize();
    }

    @Override
    public float getPadding(int i) {
        return this.padding[i];
    }

    @Override
    public void setPadding(int i, float value) {
        this.padding[i] = value;
    }

    @Override
    public void recalculateSize() {
        float width = 0.0f;
        float height = 0.0f;
        for (Tooltip.Line line : this.tooltip.lines) {
            class_241 size = line.getSize();
            width = Math.max(width, size.field_1343);
            height += size.field_1342;
        }
        float contentHeight = height;
        if (this.hasIcon()) {
            class_241 size = this.icon.getCachedSize();
            this.padding[3] = this.padding[3] + (size.field_1343 + 3.0f);
            height = Math.max(height, size.field_1342);
        }
        this.totalSize = new class_241(width += this.padding[3] + this.padding[1], height += this.padding[0] + this.padding[2]);
        if (this.hasIcon() && this.icon.getCachedSize().field_1342 > contentHeight) {
            this.padding[0] = this.padding[0] + (this.icon.getCachedSize().field_1342 - contentHeight) / 2.0f;
        }
    }

    public void draw(class_332 guiGraphics) {
        IElement icon;
        float x = this.getPadding(3);
        float y = this.getPadding(0);
        for (Tooltip.Line line : this.tooltip.lines) {
            class_241 size = line.getSize();
            line.render(guiGraphics, x, y, this.totalSize.field_1343 - this.getPadding(1), size.field_1342);
            y += size.field_1342;
        }
        if (this.tooltip.sneakyDetails) {
            class_310 mc = class_310.method_1551();
            x = (this.totalSize.field_1343 - (float)mc.field_1772.method_1727("\u25be") + 1.0f) / 2.0f;
            float yOffset = OverlayRenderer.ticks / 5.0f % 8.0f - 2.0f;
            if (yOffset <= 4.0f) {
                y = this.totalSize.field_1342 - 6.0f + yOffset;
                float alpha = 1.0f - Math.abs(yOffset) / 2.0f;
                int alphaChannel = (int)(255.0f * class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f));
                if (alphaChannel > 4) {
                    guiGraphics.method_51448().method_22903();
                    guiGraphics.method_51448().method_46416(x, y, 0.0f);
                    DisplayHelper.INSTANCE.drawText(guiGraphics, "\u25be", 0.0f, 0.0f, 0xFFFFFF | alphaChannel << 24);
                    guiGraphics.method_51448().method_22909();
                }
            }
        }
        if ((icon = this.getIcon()) != null) {
            class_241 size = icon.getCachedSize();
            class_241 offset = icon.getTranslation();
            float offsetY = offset.field_1342;
            float min = this.getPadding(0) + this.getPadding(2) + size.field_1342;
            offsetY = IWailaConfig.get().getOverlay().getIconMode() == IWailaConfig.IconMode.TOP && min < this.totalSize.field_1342 ? (offsetY += this.getPadding(0)) : (offsetY += (this.totalSize.field_1342 - size.field_1342) / 2.0f);
            float offsetX = this.getPadding(3) + offset.field_1343 - size.field_1343 - 3.0f;
            Tooltip.drawBorder(guiGraphics, offsetX, offsetY, icon);
            icon.render(guiGraphics, offsetX, offsetY, offsetX + size.field_1343, offsetY + size.field_1342);
        }
    }

    @Override
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    public boolean hasIcon() {
        return this.showIcon && Jade.CONFIG.get().getOverlay().shouldShowIcon() && this.icon != null;
    }

    @Override
    public IElement getIcon() {
        return this.hasIcon() ? this.icon : null;
    }

    @Override
    public void setIcon(IElement icon) {
        this.icon = icon;
    }

    @Override
    public class_768 getPosition() {
        class_1041 window = class_310.method_1551().method_22683();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        int x = (int)((float)window.method_4486() * overlay.tryFlip(overlay.getOverlayPosX()));
        int y = (int)((float)window.method_4502() * (1.0f - overlay.getOverlayPosY()));
        int width = (int)this.totalSize.field_1343;
        int height = (int)this.totalSize.field_1342;
        return new class_768(x, y, width, height);
    }

    @Override
    public class_241 getSize() {
        return this.totalSize;
    }

    @Override
    public void setSize(class_241 totalSize) {
        this.totalSize = totalSize;
    }
}

