/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_3675;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.KeybindOptionButton;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.gui.config.value.SliderOptionValue;
import snownee.jade.util.ClientProxy;

public class OptionsList
extends class_4265<Entry> {
    public static final class_2561 OPTION_ON = class_5244.field_24332.method_27661().method_27694(style -> style.method_36139(-4589878));
    public static final class_2561 OPTION_OFF = class_5244.field_24333.method_27661().method_27694(style -> style.method_36139(-30080));
    public final Set<Entry> forcePreview = Sets.newIdentityHashSet();
    protected final List<Entry> entries = Lists.newArrayList();
    private final Runnable diskWriter;
    public Title currentTitle;
    public class_304 selectedKey;
    private BaseOptionsScreen owner;
    private double targetScroll;
    private Entry defaultParent;
    private int lastActiveIndex;

    public OptionsList(BaseOptionsScreen owner, class_310 client, int width, int height, int y0, int y1, int entryHeight, Runnable diskWriter) {
        super(client, width, height, y0, y1, entryHeight);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.method_29344(false);
    }

    public OptionsList(BaseOptionsScreen owner, class_310 client, int width, int height, int y0, int y1, int entryHeight) {
        this(owner, client, width, height, y0, y1, entryHeight, null);
    }

    private static void walkChildren(Entry entry, Consumer<Entry> consumer) {
        consumer.accept(entry);
        for (Entry child : entry.children) {
            OptionsList.walkChildren(child, consumer);
        }
    }

    public int method_25322() {
        return Math.min(this.field_22742, 300);
    }

    protected int method_25329() {
        return this.owner.field_22789 - 6;
    }

    public void method_25307(double d) {
        super.method_25307(d);
        this.targetScroll = this.method_25341();
    }

    public boolean method_25401(double d, double e, double f) {
        double speed = !ClientProxy.hasFastScroll && class_437.method_25441() ? 4.5 : 1.5;
        this.targetScroll = this.method_25341() - f * (double)this.field_22741 * speed;
        return true;
    }

    public boolean method_25370() {
        return this.owner.method_25399() == this;
    }

    protected boolean method_25332(int i) {
        return Objects.equals(this.method_25334(), this.method_25396().get(i));
    }

    protected void method_44397(class_332 guiGraphics, int i, int j, float f, int k, int l, int m, int n, int o) {
        if (this.method_25332(k) && this.method_25405(i, j)) {
            this.method_44398(guiGraphics, m, n, o, -1, -1);
        }
        super.method_44397(guiGraphics, i, j, f, k, l, m, n, o);
    }

    protected void method_44398(class_332 guiGraphics, int i, int j, int k, int l, int m) {
        guiGraphics.method_25294(this.field_19088, i - 2, this.field_19087, i + k + 2, 0x33FFFFFF);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        int activeIndex;
        Entry pointAt;
        this.targetScroll = Math.min(this.targetScroll, (double)this.method_25331());
        double diff = this.targetScroll - super.method_25341();
        if (Math.abs(diff) > 3.0E-4) {
            super.method_25307(super.method_25341() + diff * (double)delta);
        }
        if ((pointAt = (Entry)this.method_25308(mouseX, mouseY)) instanceof Title) {
            this.method_25313(null);
        } else {
            this.method_25313((class_350.class_351)pointAt);
        }
        int n = activeIndex = pointAt != null ? this.method_25396().indexOf((Object)pointAt) : class_3532.method_15340((int)((int)this.method_25341() / this.field_22741), (int)0, (int)(this.method_25340() - 1));
        if (activeIndex >= 0 && activeIndex != this.lastActiveIndex) {
            this.lastActiveIndex = activeIndex;
            Entry entry = (Entry)this.method_25326(activeIndex);
            while (entry != null) {
                if (entry instanceof Title) {
                    this.currentTitle = (Title)entry;
                    break;
                }
                entry = entry.parent;
            }
        }
        this.method_49603(guiGraphics);
        this.method_25325(guiGraphics);
        int scrollPosX = this.method_25329();
        int j = scrollPosX + 6;
        RenderSystem.setShader(class_757::method_34543);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_44669);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.method_25311(guiGraphics, mouseX, mouseY, delta);
        int int_8 = Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4));
        if (int_8 > 0) {
            RenderSystem.setShader(class_757::method_34540);
            int int_9 = (int)((float)((this.field_19086 - this.field_19085) * (this.field_19086 - this.field_19085)) / (float)this.method_25317());
            int_9 = class_3532.method_15340((int)int_9, (int)32, (int)(this.field_19086 - this.field_19085 - 8));
            int int_10 = (int)this.method_25341() * (this.field_19086 - this.field_19085 - int_9) / int_8 + this.field_19085;
            if (int_10 < this.field_19085) {
                int_10 = this.field_19085;
            }
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
            bufferBuilder.method_22912((double)scrollPosX, (double)this.field_19086, 0.0).method_1336(0, 0, 0, 255).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_22912((double)j, (double)this.field_19086, 0.0).method_1336(0, 0, 0, 255).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22912((double)j, (double)this.field_19085, 0.0).method_1336(0, 0, 0, 255).method_22913(1.0f, 0.0f).method_1344();
            bufferBuilder.method_22912((double)scrollPosX, (double)this.field_19085, 0.0).method_1336(0, 0, 0, 255).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22912((double)scrollPosX, (double)(int_10 + int_9), 0.0).method_1336(128, 128, 128, 255).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_22912((double)j, (double)(int_10 + int_9), 0.0).method_1336(128, 128, 128, 255).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22912((double)j, (double)int_10, 0.0).method_1336(128, 128, 128, 255).method_22913(1.0f, 0.0f).method_1344();
            bufferBuilder.method_22912((double)scrollPosX, (double)int_10, 0.0).method_1336(128, 128, 128, 255).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22912((double)scrollPosX, (double)(int_10 + int_9 - 1), 0.0).method_1336(192, 192, 192, 255).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_22912((double)(j - 1), (double)(int_10 + int_9 - 1), 0.0).method_1336(192, 192, 192, 255).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22912((double)(j - 1), (double)int_10, 0.0).method_1336(192, 192, 192, 255).method_22913(1.0f, 0.0f).method_1344();
            bufferBuilder.method_22912((double)scrollPosX, (double)int_10, 0.0).method_1336(192, 192, 192, 255).method_22913(0.0f, 0.0f).method_1344();
            tessellator.method_1350();
        }
        this.method_25320(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
        guiGraphics.method_44380();
        guiGraphics.method_51422(0.35f, 0.35f, 0.35f, 1.0f);
        guiGraphics.method_25290(class_437.field_44669, 0, this.owner.field_22790 - 32, (float)this.owner.field_22789, 32.0f, this.owner.field_22789, this.owner.field_22790, 32, 32);
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.method_33284(0, this.owner.field_22790 - 32 - 4, this.owner.field_22789, this.owner.field_22790 - 32, 100, 0, -301989888);
    }

    public void save() {
        this.method_25396().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public <T extends Entry> T add(T entry) {
        this.entries.add(entry);
        if (entry instanceof Title) {
            this.setDefaultParent(entry);
        } else if (this.defaultParent != null) {
            entry.parent(this.defaultParent);
        }
        return entry;
    }

    @Nullable
    public Entry getEntryAt(double x, double y) {
        return (Entry)this.method_25308(x, y);
    }

    public int method_25337(int i) {
        return super.method_25337(i);
    }

    public int method_25319(int i) {
        return super.method_25319(i);
    }

    public void setDefaultParent(Entry defaultParent) {
        this.defaultParent = defaultParent;
    }

    public class_5250 title(String string) {
        return this.add(new Title(string)).getTitle();
    }

    public OptionValue<?> slider(String optionName, float value, Consumer<Float> setter) {
        return this.slider(optionName, value, setter, 0.0f, 1.0f, FloatUnaryOperator.identity());
    }

    public OptionValue<?> slider(String optionName, float value, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        return this.add(new SliderOptionValue(optionName, value, setter, min, max, aligner));
    }

    public <T> OptionValue<?> input(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        return this.add(new InputOptionValue<T>(this::updateSaveState, optionName, value, setter, validator));
    }

    public <T> OptionValue<?> input(String optionName, T value, Consumer<T> setter) {
        return this.input(optionName, value, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public OptionValue<?> choices(String optionName, boolean value, BooleanConsumer setter) {
        return this.choices(optionName, value, setter, null);
    }

    public OptionValue<?> choices(String optionName, boolean value, BooleanConsumer setter, @Nullable Consumer<class_5676.class_5677<Boolean>> builderConsumer) {
        class_5676.class_5677 builder = class_5676.method_32607((class_2561)OPTION_ON, (class_2561)OPTION_OFF);
        if (builderConsumer != null) {
            builderConsumer.accept((class_5676.class_5677<Boolean>)builder);
        }
        return this.add(new CycleOptionValue<Boolean>(optionName, (class_5676.class_5677<Boolean>)builder, value, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> OptionValue<?> choices(String optionName, T value, Consumer<T> setter) {
        return this.choices(optionName, value, setter, null);
    }

    public <T extends Enum<T>> OptionValue<?> choices(String optionName, T value, Consumer<T> setter, @Nullable Consumer<class_5676.class_5677<T>> builderConsumer) {
        List<Enum> values = Arrays.asList((Enum[])value.getClass().getEnumConstants());
        class_5676.class_5677 builder = class_5676.method_32606(v -> {
            String name;
            return switch (name = v.name().toLowerCase(Locale.ENGLISH)) {
                case "on" -> OPTION_ON;
                case "off" -> OPTION_OFF;
                default -> Entry.makeTitle(optionName + "_" + name);
            };
        }).method_32620(values);
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return this.add(new CycleOptionValue<T>(optionName, builder, value, setter));
    }

    public <T> OptionValue<?> choices(String optionName, T value, List<T> values, Consumer<T> setter) {
        return this.add(new CycleOptionValue<T>(optionName, class_5676.method_32606(v -> class_2561.method_43470((String)v.toString())).method_32620(values), value, setter));
    }

    public void keybind(class_304 keybind) {
        this.add(new KeybindOptionButton(this, keybind));
    }

    public void removed() {
        this.forcePreview.clear();
        for (Entry entry : this.entries) {
            entry.parent = null;
            if (entry.children.isEmpty()) continue;
            entry.children.clear();
        }
        this.method_25339();
        this.owner = null;
    }

    public void updateSearch(String search) {
        this.method_25339();
        if (search.isBlank()) {
            this.entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            return;
        }
        LinkedHashSet matches = Sets.newLinkedHashSet();
        String[] keywords = search.split("\\s+");
        for (Entry entry : this.entries) {
            int bingo = 0;
            block1: for (String keyword : keywords) {
                keyword = keyword.toLowerCase(Locale.ENGLISH);
                for (String message : entry.getMessages()) {
                    if (!message.contains(keyword)) continue;
                    ++bingo;
                    continue block1;
                }
            }
            if (bingo != keywords.length) continue;
            OptionsList.walkChildren(entry, matches::add);
            while (entry.parent != null) {
                entry = entry.parent;
                matches.add(entry);
            }
        }
        for (Entry entry : this.entries) {
            if (!matches.contains((Object)entry)) continue;
            this.method_25321((class_350.class_351)entry);
        }
    }

    public void updateSaveState() {
        for (Entry entry : this.entries) {
            OptionValue value;
            if (!(entry instanceof OptionValue) || (value = (OptionValue)entry).isValidValue()) continue;
            this.owner.saveButton.field_22763 = false;
            return;
        }
        this.owner.saveButton.field_22763 = true;
    }

    public void showOnTop(Entry entry) {
        this.targetScroll = this.field_22741 * this.method_25396().indexOf((Object)entry) + 1;
    }

    public void resetMappingAndUpdateButtons() {
        for (Entry entry : this.entries) {
            if (!(entry instanceof KeybindOptionButton)) continue;
            KeybindOptionButton button = (KeybindOptionButton)entry;
            button.refresh(this.selectedKey);
        }
    }

    public boolean method_25404(int i, int j, int k) {
        if (this.selectedKey != null) {
            class_315 options = class_310.method_1551().field_1690;
            if (i == 256) {
                options.method_1641(this.selectedKey, class_3675.field_16237);
            } else {
                options.method_1641(this.selectedKey, class_3675.method_15985((int)i, (int)j));
            }
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
            return true;
        }
        return super.method_25404(i, j, k);
    }

    public static class Entry
    extends class_4265.class_4266<Entry> {
        protected final class_310 client;
        private final List<String> messages = Lists.newArrayList();
        private final List<class_339> widgets = Lists.newArrayList();
        private final List<Vector2i> widgetOffsets = Lists.newArrayList();
        @Nullable
        protected String description;
        private Entry parent;
        private List<Entry> children = List.of();

        public Entry() {
            this.client = class_310.method_1551();
        }

        public static class_5250 makeTitle(String key) {
            return class_2561.method_43471((String)Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return class_156.method_646((String)"config", (class_2960)new class_2960("jade", key));
        }

        public class_339 getFirstWidget() {
            return this.widgets.isEmpty() ? null : this.widgets.get(0);
        }

        public void addWidget(class_339 widget, int offsetX) {
            this.addWidget(widget, offsetX, -widget.method_25364() / 2);
        }

        public void addWidget(class_339 widget, int offsetX, int offsetY) {
            this.widgets.add(widget);
            this.widgetOffsets.add(new Vector2i(offsetX, offsetY));
        }

        public List<? extends class_339> method_25396() {
            return this.widgets;
        }

        public List<? extends class_6379> method_37025() {
            return this.method_25396();
        }

        public void method_25343(class_332 guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            for (class_339 widget : this.widgets) {
                Vector2i offset = this.widgetOffsets.get(this.widgets.indexOf(widget));
                widget.method_46421(rowLeft + width - 110 + offset.x);
                widget.method_46419(rowTop + height / 2 + offset.y);
                widget.method_25394(guiGraphics, mouseX, mouseY, deltaTime);
            }
        }

        public void setDisabled(boolean b) {
            for (class_339 widget : this.widgets) {
                boolean bl = widget.field_22763 = !b;
                if (!(widget instanceof class_342)) continue;
                class_342 box = (class_342)widget;
                box.method_1888(!b);
            }
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public int getTextX(int width) {
            return 0;
        }

        public int getTextWidth() {
            return 0;
        }

        public void parent(Entry parent) {
            this.parent = parent;
            if (parent.children.isEmpty()) {
                parent.children = Lists.newArrayList();
            }
            parent.children.add(this);
        }

        public Entry parent() {
            return this.parent;
        }

        public final List<String> getMessages() {
            return this.messages;
        }

        public void addMessage(String message) {
            this.messages.add(class_3544.method_15440((String)message).toLowerCase(Locale.ENGLISH));
        }

        public void addMessageKey(String key) {
            if (class_1074.method_4663((String)(key = Entry.makeKey(key + "_extra_msg")))) {
                this.addMessage(class_1074.method_4662((String)key, (Object[])new Object[0]));
            }
        }
    }

    public static class Title
    extends Entry {
        private final class_5250 title;
        private int x;

        public Title(String key) {
            this.title = Title.makeTitle(key);
            this.addMessageKey(key);
            this.addMessage(this.title.getString());
            key = Title.makeKey(key + "_desc");
            if (class_1074.method_4663((String)key)) {
                this.description = class_1074.method_4662((String)key, (Object[])new Object[0]);
                this.addMessage(this.description);
            }
        }

        public Title(class_5250 title) {
            this.title = title;
        }

        public class_5250 getTitle() {
            return this.title;
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            this.x = rowLeft;
            class_327 class_3272 = this.client.field_1772;
            int n = this.getTextX(width);
            Objects.requireNonNull(this.client.field_1772);
            guiGraphics.method_27535(class_3272, (class_2561)this.title, n, rowTop + height - 9, 0xFFFFFF);
        }

        @Override
        public int getTextX(int width) {
            return this.x + (width - this.client.field_1772.method_27525((class_5348)this.title)) / 2;
        }

        @Override
        public int getTextWidth() {
            return this.client.field_1772.method_27525((class_5348)this.title);
        }
    }
}

