/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.FluidTextHelper;

public class FluidView {
    public static final class_2561 EMPTY_FLUID = class_2561.method_43471((String)"jade.fluid.empty");
    public IElement overlay;
    public String current;
    public String max;
    public float ratio;
    @Nullable
    public class_2561 fluidName;
    @Nullable
    public class_2561 overrideText;

    public FluidView(IElement overlay) {
        this.overlay = overlay;
        Objects.requireNonNull(overlay);
    }

    @Nullable
    public static FluidView readDefault(class_2487 tag) {
        long capacity = tag.method_10537("capacity");
        if (capacity <= 0L) {
            return null;
        }
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(tag.method_10558("fluid")));
        class_2487 nbt = tag.method_10545("tag") ? tag.method_10562("tag") : null;
        long amount = tag.method_10537("amount");
        JadeFluidObject fluidObject = JadeFluidObject.of(fluid, amount, nbt);
        FluidView fluidView = new FluidView(IElementHelper.get().fluid(fluidObject));
        fluidView.fluidName = CommonProxy.getFluidName(fluidObject);
        if (amount <= 0L) {
            fluidView.overrideText = EMPTY_FLUID;
        }
        fluidView.current = FluidTextHelper.getUnicodeMillibuckets(amount, true);
        fluidView.max = FluidTextHelper.getUnicodeMillibuckets(capacity, true);
        fluidView.ratio = (float)((double)amount / (double)capacity);
        return fluidView;
    }

    public static class_2487 writeDefault(JadeFluidObject fluidObject, long capacity) {
        class_2487 tag = new class_2487();
        if (capacity <= 0L) {
            return tag;
        }
        tag.method_10582("fluid", class_7923.field_41173.method_10221((Object)fluidObject.getType()).toString());
        tag.method_10544("amount", fluidObject.getAmount());
        tag.method_10544("capacity", capacity);
        if (fluidObject.getTag() != null) {
            tag.method_10566("tag", (class_2520)fluidObject.getTag());
        }
        return tag;
    }
}

