/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2384;
import net.minecraft.class_239;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2531;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import net.minecraft.class_636;
import net.minecraft.class_768;
import net.minecraft.class_8170;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.HomeConfigScreen;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;

public final class JadeClient {
    public static class_304 openConfig;
    public static class_304 showOverlay;
    public static class_304 toggleLiquid;
    public static class_304 showDetails;
    public static class_304 narrate;
    public static class_304 showRecipes;
    public static class_304 showUses;
    public static boolean hideModName;
    private static boolean translationChecked;
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;

    public static void init() {
        openConfig = ClientProxy.registerKeyBinding("config", 320);
        showOverlay = ClientProxy.registerKeyBinding("show_overlay", 321);
        toggleLiquid = ClientProxy.registerKeyBinding("toggle_liquid", 322);
        if (ClientProxy.shouldRegisterRecipeViewerKeys()) {
            showRecipes = ClientProxy.registerKeyBinding("show_recipes", 323);
            showUses = ClientProxy.registerKeyBinding("show_uses", 324);
        }
        narrate = ClientProxy.registerKeyBinding("narrate", 325);
        showDetails = ClientProxy.registerDetailsKeyBinding();
        ClientProxy.registerReloadListener(ModIdentification.INSTANCE);
    }

    public static void onKeyPressed(int action) {
        while (openConfig.method_1436()) {
            Jade.CONFIG.invalidate();
            class_310.method_1551().method_1507((class_437)new HomeConfigScreen(null));
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        while (showOverlay.method_1436()) {
            IWailaConfig.DisplayMode mode = general.getDisplayMode();
            if (mode != IWailaConfig.DisplayMode.TOGGLE) continue;
            general.setDisplayTooltip(!general.shouldDisplayTooltip());
            if (!general.shouldDisplayTooltip() && general.hintOverlayToggle) {
                class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)class_2561.method_43471((String)"toast.jade.toggle_hint.1"), (class_2561)class_2561.method_43469((String)"toast.jade.toggle_hint.2", (Object[])new Object[]{showOverlay.method_16007()}));
                general.hintOverlayToggle = false;
            }
            Jade.CONFIG.save();
        }
        while (toggleLiquid.method_1436()) {
            general.setDisplayFluids(!general.shouldDisplayFluids());
            Jade.CONFIG.save();
        }
        while (narrate.method_1436()) {
            if (general.getTTSMode() == IWailaConfig.TTSMode.TOGGLE) {
                general.toggleTTS();
                Jade.CONFIG.save();
                continue;
            }
            if (WailaTickHandler.instance().tooltipRenderer == null) continue;
            WailaTickHandler.narrate(WailaTickHandler.instance().tooltipRenderer.getTooltip(), false);
        }
    }

    public static void onGui(class_437 screen) {
        if (!translationChecked && screen instanceof class_442 && CommonProxy.isDevEnv()) {
            translationChecked = true;
            ArrayList keys = Lists.newArrayList();
            for (class_2960 id : PluginConfig.INSTANCE.getKeys()) {
                String key = "config.jade.plugin_%s.%s".formatted(id.method_12836(), id.method_12832());
                if (class_1074.method_4663((String)key)) continue;
                keys.add(key);
            }
            if (!keys.isEmpty()) {
                throw new AssertionError((Object)"Missing config translation: %s".formatted(Joiner.on((char)',').join((Iterable)keys)));
            }
        }
    }

    public static void onTooltip(List<class_2561> tooltip, class_1799 stack) {
        JadeClient.appendModName(tooltip, stack);
        if (Jade.CONFIG.get().getGeneral().isDebug() && stack.method_7985()) {
            tooltip.add(class_2512.method_32270((class_2520)stack.method_7969()));
        }
    }

    private static void appendModName(List<class_2561> tooltip, class_1799 stack) {
        if (hideModName || !Jade.CONFIG.get().getGeneral().showItemModNameTooltip()) {
            return;
        }
        String name = String.format(Jade.CONFIG.get().getFormatting().getModName(), ModIdentification.getModName(stack));
        tooltip.add((class_2561)class_2561.method_43470((String)name));
    }

    @Nullable
    public static Accessor<?> builtInOverrides(class_239 hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (WailaClientRegistration.INSTANCE.maybeLowVisionUser()) {
            return accessor;
        }
        if (accessor instanceof BlockAccessor) {
            BlockAccessor target = (BlockAccessor)accessor;
            class_1657 player = accessor.getPlayer();
            if (player.method_7337() || player.method_7325()) {
                return accessor;
            }
            IWailaClientRegistration client = VanillaPlugin.CLIENT_REGISTRATION;
            if (target.getBlock() instanceof class_2531) {
                class_2680 state = VanillaPlugin.getCorrespondingNormalChest(target.getBlockState());
                if (state != target.getBlockState()) {
                    return client.blockAccessor().from(target).blockState(state).build();
                }
            } else {
                if (target.getBlock() instanceof class_2384) {
                    class_2248 block = ((class_2384)target.getBlock()).method_10271();
                    return client.blockAccessor().from(target).blockState(block.method_9564()).build();
                }
                if (target.getBlock() == class_2246.field_27879) {
                    class_2248 block = class_2246.field_10491;
                    return client.blockAccessor().from(target).blockState(block.method_9564()).build();
                }
                class_2248 block = target.getBlock();
                if (block instanceof class_8170) {
                    class_8170 brushable = (class_8170)block;
                    block = brushable.method_49810();
                    return client.blockAccessor().from(target).blockState(block.method_9564()).build();
                }
            }
        }
        return accessor;
    }

    public static void drawBreakingProgress(ITooltip tooltip, class_768 rect, class_332 guiGraphics, Accessor<?> accessor) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        class_310 mc = class_310.method_1551();
        class_636 playerController = mc.field_1761;
        if (playerController == null || mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        class_2680 state = mc.field_1687.method_8320(playerController.field_3714);
        if (playerController.method_2923()) {
            canHarvest = CommonProxy.isCorrectToolForDrops(state, (class_1657)mc.field_1724);
        }
        int color = canHarvest ? 0xFFFFFF : 0xFF4444;
        int height = rect.method_3320();
        int width = rect.method_3319();
        if (!IWailaConfig.get().getOverlay().getSquare()) {
            --height;
            width -= 2;
        }
        progressAlpha += mc.method_1534() * (playerController.method_2923() ? 0.1f : -0.1f);
        if (playerController.method_2923()) {
            progressAlpha = Math.min(progressAlpha, 0.53f);
            float progress = state.method_26165((class_1657)mc.field_1724, (class_1922)mc.field_1724.method_37908(), playerController.field_3714);
            if (playerController.field_3715 + progress >= 1.0f) {
                progressAlpha = 1.0f;
            }
            progress = playerController.field_3715 + mc.method_1488() * progress;
            savedProgress = progress = class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f);
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        color = IWailaConfig.IConfigOverlay.applyAlpha(color, progressAlpha);
        DisplayHelper.fill(guiGraphics, 0.0f, (float)(height - 1), (float)width * savedProgress, (float)height, color);
    }

    public static class_5250 format(String s, Object ... objects) {
        try {
            return class_2561.method_43470((String)MessageFormat.format(class_1074.method_4662((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return class_2561.method_43469((String)s, (Object[])objects);
        }
    }
}

