/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds.classpath;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class LibraryClasspaths {
    public static Path getClasspathEntry(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        URL resource = clazz.getResource(clazz.getSimpleName() + ".class");
        if (resource == null) {
            return null;
        }
        return switch (resource.getProtocol()) {
            case "jar" -> LibraryClasspaths.getFilePathForJarUrl(resource);
            case "file" -> LibraryClasspaths.getBaseDirectoryForFileUrl(resource, clazz);
            default -> null;
        };
    }

    private static Path getBaseDirectoryForFileUrl(URL resource, Class<?> clazz) {
        String pathFragment = clazz.getName().replace('.', '/') + ".class";
        String path = URLDecoder.decode(resource.getPath(), StandardCharsets.UTF_8);
        int idx = path.lastIndexOf(pathFragment);
        if (idx == -1) {
            return null;
        }
        return Path.of(path.substring(0, idx), new String[0]);
    }

    private static Path getFilePathForJarUrl(URL url) {
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            URL resolvedUrl = connection.getJarFileURL();
            return Path.of(resolvedUrl.toURI());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Couldn't find file path for Jar URL", e);
        }
    }
}

