/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.color;

import me.jellysquid.mods.sodium.client.util.color.ColorU8;

public class ColorABGR
implements ColorU8 {
    public static int pack(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
    }

    public static int withAlpha(int rgb, float alpha) {
        return ((int)(alpha * 255.0f) & 0xFF) << 24 | rgb & 0xFFFFFF;
    }

    public static int pack(float r, float g, float b, float a) {
        return ColorABGR.pack((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int mul(int color, float rw, float gw, float bw) {
        float r = (float)ColorABGR.unpackRed(color) * rw;
        float g = (float)ColorABGR.unpackGreen(color) * gw;
        float b = (float)ColorABGR.unpackBlue(color) * bw;
        return ColorABGR.pack((int)r, (int)g, (int)b, 255);
    }

    public static int mul(int color, float w) {
        return ColorABGR.mul(color, w, w, w);
    }

    public static int unpackRed(int color) {
        return color & 0xFF;
    }

    public static int unpackGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int unpackBlue(int color) {
        return color >> 16 & 0xFF;
    }

    public static int unpackAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int pack(float r, float g, float b) {
        return ColorABGR.pack(r, g, b, 255.0f);
    }
}

