/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item.rule.file;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.extensions.Kt_commonKt;
import org.anti_ad.mc.common.extensions.Kt_numberKt;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.item.rule.file.MissingParameterException;
import org.anti_ad.mc.ipnext.item.rule.file.RuleDefinition;
import org.anti_ad.mc.ipnext.item.rule.file.RuleDefinition$Status;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFile;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFileRegister;
import org.anti_ad.mc.ipnext.item.rule.file.SelfReferenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RuleFileRegister$RuleFinder {
    @NotNull
    private final String ruleName;

    public RuleFileRegister$RuleFinder(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.ruleName = string;
    }

    @NotNull
    public final String getRuleName() {
        return this.ruleName;
    }

    @Nullable
    public final RuleDefinition searchCustomRule() {
        for (Object object : CollectionsKt.reversed((Iterable)RuleFileRegister.access$getRuleFiles$p())) {
            Map map = ((RuleFile)object).getRulesMap();
            if (!map.containsKey(this.ruleName)) continue;
            object = ((RuleFile)object).getFileName();
            Log.INSTANCE.trace("Searching rule @" + this.ruleName + " at file " + (String)object);
            Object object2 = (List)MapsKt.getValue((Map)map, (Object)this.ruleName);
            Log.INSTANCE.indent();
            object2 = this.findUsableRule(CollectionsKt.asReversedMutable((List)object2), (String)object);
            Log.INSTANCE.unindent();
            map.remove(this.ruleName);
            if (object2 != null) {
                Log.INSTANCE.trace("    > Found @" + this.ruleName + " at file " + (String)object);
                RuleFileRegister.INSTANCE.getLoadedFileNames().add(object);
                return object2;
            }
            Log.INSTANCE.trace("    > None of @" + this.ruleName + " usable at file " + (String)object);
        }
        Log.INSTANCE.trace(">> @" + this.ruleName + " not found in all files");
        return null;
    }

    private final RuleDefinition findUsableRule(List object, String string) {
        int n2 = object.size();
        object = object.iterator();
        while (object.hasNext()) {
            RuleDefinition ruleDefinition = (RuleDefinition)object.next();
            Log.INSTANCE.trace("Instantiating rule @" + this.ruleName + "#" + n2);
            Log.INSTANCE.indent();
            try {
                ruleDefinition.createCustomRule();
                if (ruleDefinition.getStatus() == RuleDefinition$Status.SUCCESS) {
                    return ruleDefinition;
                }
                Log.INSTANCE.error("interesting rule @" + this.ruleName + "#" + n2 + " (at file " + string + ")");
                --n2;
            }
            catch (Exception exception) {
                Log.INSTANCE.warn("Error in " + Kt_numberKt.getOrdinalName((int)n2) + " '@" + this.ruleName + "' (at file " + string + ")");
                Log.INSTANCE.warn("  > " + Kt_commonKt.getUsefulName(exception.getClass()) + ": " + exception.getMessage());
                Exception exception2 = exception;
                if (!((exception2 instanceof NoSuchElementException ? true : exception2 instanceof SelfReferenceException) ? true : exception2 instanceof MissingParameterException)) {
                    exception.printStackTrace();
                }
                --n2;
            }
            finally {
                Log.INSTANCE.unindent();
            }
        }
        return null;
    }
}

