/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public final class ItemLightSources {
    private static final List<ItemLightSource> ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();
    private static final List<ItemLightSource> STATIC_ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();

    private ItemLightSources() {
        throw new UnsupportedOperationException("ItemLightSources only contains static definitions.");
    }

    public static void load(class_3300 resourceManager) {
        ITEM_LIGHT_SOURCES.clear();
        resourceManager.method_14488("dynamiclights/item", path -> path.method_12832().endsWith(".json")).forEach(ItemLightSources::load);
        ITEM_LIGHT_SOURCES.addAll(STATIC_ITEM_LIGHT_SOURCES);
    }

    private static void load(class_2960 resourceId, class_3298 resource) {
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            ItemLightSource.fromJson(id, json).ifPresent(data -> {
                if (!STATIC_ITEM_LIGHT_SOURCES.contains(data)) {
                    ItemLightSources.register(data);
                }
            });
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.get().warn("Failed to load item light source \"" + id + "\".");
        }
    }

    private static void register(ItemLightSource data) {
        for (ItemLightSource other : ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            LambDynLights.get().warn("Failed to register item light source \"" + data.id() + "\", duplicates item \"" + class_7923.field_41178.method_10221((Object)data.item()) + "\" found in \"" + other.id() + "\".");
            return;
        }
        ITEM_LIGHT_SOURCES.add(data);
    }

    public static void registerItemLightSource(ItemLightSource data) {
        for (ItemLightSource other : STATIC_ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            LambDynLights.get().warn("Failed to register item light source \"" + data.id() + "\", duplicates item \"" + class_7923.field_41178.method_10221((Object)data.item()) + "\" found in \"" + other.id() + "\".");
            return;
        }
        STATIC_ITEM_LIGHT_SOURCES.add(data);
    }

    public static int getLuminance(class_1799 stack, boolean submergedInWater) {
        for (ItemLightSource data : ITEM_LIGHT_SOURCES) {
            if (data.item() != stack.method_7909()) continue;
            return data.getLuminance(stack, submergedInWater);
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return ItemLightSource.BlockItemLightSource.getLuminance(stack, blockItem.method_7711().method_9564());
        }
        return 0;
    }
}

