/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.tprequest.util;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import committee.nova.tprequest.permnode.PermNode;
import committee.nova.tprequest.request.TeleportRequest;
import committee.nova.tprequest.storage.ServerStorage;
import java.util.Optional;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Utilities {
    public static final DynamicCommandExceptionType REQUEST_NOT_FOUND = new DynamicCommandExceptionType(uuid -> class_2561.method_43469((String)"msg.tprequest.notfound", (Object[])new Object[]{uuid}));

    public static class_2561 getPlayerName(MinecraftServer server, UUID uuid) {
        class_3222 p = server.method_3760().method_14602(uuid);
        return p == null ? class_2561.method_43471((String)"msg.tprequest.unknown_player") : p.method_5477();
    }

    public static Optional<class_3222> getPlayer(MinecraftServer server, UUID player) {
        return Optional.ofNullable(server.method_3760().method_14602(player));
    }

    public static boolean isProduction() {
        return !FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean checkPerm(class_2168 player, PermNode permNode, int defaultRequiredLevel) {
        return Permissions.check((class_2172)player, (String)permNode.getNode(), (int)defaultRequiredLevel);
    }

    public static double getActualSecond(int tick) {
        return (double)tick / 20.0;
    }

    public static String getActualSecondStr(int tick) {
        return String.format("%.1f", (double)tick / 20.0);
    }

    public static TeleportRequest parseRequest(UUID id) throws CommandSyntaxException {
        ImmutableList<TeleportRequest> l = ServerStorage.getRequestCopied();
        for (TeleportRequest r : l) {
            if (!r.getId().equals(id)) continue;
            return r;
        }
        throw REQUEST_NOT_FOUND.create((Object)id.toString());
    }
}

