/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.tprequest.request;

import committee.nova.tprequest.TeleportationRequest;
import committee.nova.tprequest.callback.TeleportationCallback;
import committee.nova.tprequest.util.Utilities;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public interface TeleportRequest {
    public UUID getId();

    public boolean tick();

    public boolean execute(MinecraftServer var1);

    public void setIgnored(boolean var1);

    public boolean isIgnored();

    public int getExpirationTime();

    public void setExpirationTime(int var1);

    public UUID getSender();

    public UUID getReceiver();

    public TeleportationType getType();

    public class_5250 getSummary(MinecraftServer var1);

    default public class_5250 getCmdSuggestion(MinecraftServer server) {
        return this.getSummary(server).method_27693(",").method_10852((class_2561)class_2561.method_43470((String)this.getId().toString()));
    }

    default public boolean isSender(class_3222 player) {
        return this.getSender().equals(player.method_5667());
    }

    default public boolean isReceiver(class_3222 player) {
        return this.getReceiver().equals(player.method_5667());
    }

    default public boolean isRelevantTo(class_3222 player) {
        return this.isSender(player) || this.isReceiver(player);
    }

    public static enum TeleportationType {
        TO,
        HERE;

    }

    public static class Here
    implements TeleportRequest {
        private final UUID sender;
        private final UUID receiver;
        private final UUID uuid = UUID.randomUUID();
        private int timeout = TeleportationRequest.getExpirationTime();
        private boolean ignored = false;

        public Here(UUID sender, UUID receiver) {
            this.sender = sender;
            this.receiver = receiver;
        }

        @Override
        public UUID getId() {
            return this.uuid;
        }

        @Override
        public boolean tick() {
            --this.timeout;
            return this.timeout <= 0;
        }

        @Override
        public boolean execute(MinecraftServer server) {
            class_3222 oS = server.method_3760().method_14602(this.sender);
            class_3222 oR = server.method_3760().method_14602(this.receiver);
            if (oS == null || oR == null) {
                return false;
            }
            class_5321 formerWorld = oR.method_37908().method_27983();
            class_243 formerPos = oR.method_19538();
            oR.method_14251(oS.method_51469(), oS.method_23317(), oS.method_23318(), oS.method_23321(), oS.method_36454(), oS.method_36455());
            ((TeleportationCallback)TeleportationCallback.EVENT.invoker()).postTeleport(oS, oR, this.getType(), (class_5321<class_1937>)formerWorld, formerPos);
            return true;
        }

        @Override
        public void setIgnored(boolean ignored) {
            this.ignored = ignored;
        }

        @Override
        public boolean isIgnored() {
            return this.ignored;
        }

        @Override
        public int getExpirationTime() {
            return this.timeout;
        }

        @Override
        public void setExpirationTime(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public UUID getSender() {
            return this.sender;
        }

        @Override
        public UUID getReceiver() {
            return this.receiver;
        }

        @Override
        public TeleportationType getType() {
            return TeleportationType.HERE;
        }

        @Override
        public class_5250 getSummary(MinecraftServer server) {
            return class_2561.method_43469((String)"format.tprequest.summary.here", (Object[])new Object[]{Utilities.getPlayerName(server, this.sender), Utilities.getPlayerName(server, this.receiver)});
        }
    }

    public static class To
    implements TeleportRequest {
        private final UUID sender;
        private final UUID receiver;
        private final UUID uuid = UUID.randomUUID();
        private int timeout = TeleportationRequest.getExpirationTime();
        private boolean ignored = false;

        public To(UUID sender, UUID receiver) {
            this.sender = sender;
            this.receiver = receiver;
        }

        @Override
        public UUID getId() {
            return this.uuid;
        }

        @Override
        public boolean tick() {
            --this.timeout;
            return this.timeout <= 0;
        }

        @Override
        public boolean execute(MinecraftServer server) {
            class_3222 oS = server.method_3760().method_14602(this.sender);
            class_3222 oR = server.method_3760().method_14602(this.receiver);
            if (oS == null || oR == null) {
                return false;
            }
            class_5321 formerWorld = oS.method_37908().method_27983();
            class_243 formerPos = oS.method_19538();
            oS.method_14251(oR.method_51469(), oR.method_23317(), oR.method_23318(), oR.method_23321(), oR.method_36454(), oR.method_36455());
            ((TeleportationCallback)TeleportationCallback.EVENT.invoker()).postTeleport(oS, oR, this.getType(), (class_5321<class_1937>)formerWorld, formerPos);
            return true;
        }

        @Override
        public void setIgnored(boolean ignored) {
            this.ignored = ignored;
        }

        @Override
        public boolean isIgnored() {
            return this.ignored;
        }

        @Override
        public int getExpirationTime() {
            return this.timeout;
        }

        @Override
        public void setExpirationTime(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public UUID getSender() {
            return this.sender;
        }

        @Override
        public UUID getReceiver() {
            return this.receiver;
        }

        @Override
        public TeleportationType getType() {
            return TeleportationType.TO;
        }

        @Override
        public class_5250 getSummary(MinecraftServer server) {
            return class_2561.method_43469((String)"format.tprequest.summary.to", (Object[])new Object[]{Utilities.getPlayerName(server, this.sender), Utilities.getPlayerName(server, this.receiver)}).method_27692(class_124.field_1068);
        }
    }
}

