/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.tprequest.command.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import committee.nova.tprequest.TeleportationRequest;
import committee.nova.tprequest.api.ITeleportable;
import committee.nova.tprequest.command.impl.CommandImpl;
import committee.nova.tprequest.permnode.PermNode;
import committee.nova.tprequest.request.TeleportRequest;
import committee.nova.tprequest.storage.ServerStorage;
import committee.nova.tprequest.util.Utilities;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class CommandInit {
    private static final Map<String, LiteralCommandNode<class_2168>> cmds = Maps.newHashMap();

    public static void init(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 env) {
        cmds.put("trtpa", (LiteralCommandNode<class_2168>)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trtpa").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPA, 0))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 sender = src.method_44023();
            class_3222 receiver = class_2186.method_9315((CommandContext)ctx, (String)"player");
            if (receiver.equals((Object)sender) && Utilities.isProduction()) {
                src.method_9213((class_2561)class_2561.method_43471((String)"msg.tprequest.self"));
                return 0;
            }
            ITeleportable t = (ITeleportable)sender;
            if (t.isCoolingDown()) {
                src.method_9213((class_2561)class_2561.method_43469((String)"msg.tprequest.cd", (Object[])new Object[]{Utilities.getActualSecondStr(t.getTeleportCd())}));
                return 0;
            }
            TeleportRequest.To request = new TeleportRequest.To(sender.method_5667(), receiver.method_5667());
            int timeout = request.getExpirationTime();
            boolean sent = ServerStorage.addRequest(request);
            if (!sent) {
                src.method_9213((class_2561)class_2561.method_43471((String)"msg.tprequest.existed"));
                return 0;
            }
            String id = request.getId().toString();
            src.method_9226(() -> class_2561.method_43469((String)"msg.tprequest.sent", (Object[])new Object[]{Utilities.getActualSecondStr(timeout)}).method_27692(class_124.field_1060), false);
            class_5250 summary = request.getSummary(src.method_9211());
            src.method_9226(() -> CommandInit.lambda$init$2(id, (class_2561)summary), false);
            receiver.method_7353((class_2561)class_2561.method_43469((String)"msg.tprequest.info.to", (Object[])new Object[]{sender.method_5477()}).method_27692(class_124.field_1054), false);
            receiver.method_7353((class_2561)class_2561.method_43469((String)"msg.tprequest.respond.format", (Object[])new Object[]{class_2561.method_43471((String)"selection.tprequest.accept").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpaccept " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.accept.info", (Object[])new Object[]{summary})))), class_2561.method_43471((String)"selection.tprequest.deny").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpdeny " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.deny.info", (Object[])new Object[]{summary})))), class_2561.method_43471((String)"selection.tprequest.ignore").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpignore " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.ignore.info", (Object[])new Object[]{summary}))))}), false);
            return 1;
        }))).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPA, 0))));
        cmds.put("trtpahere", (LiteralCommandNode<class_2168>)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trtpahere").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPAHERE, 0))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 sender = src.method_44023();
            class_3222 receiver = class_2186.method_9315((CommandContext)ctx, (String)"player");
            if (receiver.equals((Object)sender) && Utilities.isProduction()) {
                src.method_9213((class_2561)class_2561.method_43471((String)"msg.tprequest.self"));
                return 0;
            }
            ITeleportable t = (ITeleportable)sender;
            if (t.isCoolingDown()) {
                src.method_9213((class_2561)class_2561.method_43469((String)"msg.tprequest.cd", (Object[])new Object[]{Utilities.getActualSecondStr(t.getTeleportCd())}));
                return 0;
            }
            TeleportRequest.Here request = new TeleportRequest.Here(sender.method_5667(), receiver.method_5667());
            int timeout = request.getExpirationTime();
            boolean sent = ServerStorage.addRequest(request);
            if (!sent) {
                src.method_9213((class_2561)class_2561.method_43471((String)"msg.tprequest.existed"));
                return 0;
            }
            String id = request.getId().toString();
            src.method_9226(() -> class_2561.method_43469((String)"msg.tprequest.sent", (Object[])new Object[]{Utilities.getActualSecondStr(timeout)}).method_27692(class_124.field_1060), false);
            class_5250 summary = request.getSummary(src.method_9211());
            src.method_9226(() -> CommandInit.lambda$init$7(id, (class_2561)summary), false);
            receiver.method_7353((class_2561)class_2561.method_43469((String)"msg.tprequest.info.here", (Object[])new Object[]{sender.method_5477()}).method_27692(class_124.field_1054), false);
            receiver.method_7353((class_2561)class_2561.method_43469((String)"msg.tprequest.respond.format", (Object[])new Object[]{class_2561.method_43471((String)"selection.tprequest.accept").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpaccept " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.accept.info", (Object[])new Object[]{summary})))), class_2561.method_43471((String)"selection.tprequest.deny").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpdeny " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.deny.info", (Object[])new Object[]{summary})))), class_2561.method_43471((String)"selection.tprequest.ignore").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpignore " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.ignore.info", (Object[])new Object[]{summary}))))}), false);
            return 1;
        }))).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPAHERE, 0))));
        cmds.put("trtpcancel", (LiteralCommandNode<class_2168>)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trtpcancel").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPCANCEL, 0))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            TeleportRequest request = Utilities.parseRequest(class_5242.method_27645((CommandContext)ctx, (String)"id"));
            class_3222 srcPlayer = src.method_44023();
            if (srcPlayer == null) {
                return 0;
            }
            if (!request.getSender().equals(srcPlayer.method_5667())) {
                src.method_9213((class_2561)class_2561.method_43469((String)"msg.tprequest.notfound", (Object[])new Object[]{""}));
                return 0;
            }
            if (!ServerStorage.requests.remove(request)) {
                src.method_9213((class_2561)class_2561.method_43471((String)"msg.tprequest.already_removed"));
                return 0;
            }
            MinecraftServer server = src.method_9211();
            if (!request.isIgnored()) {
                Utilities.getPlayer(server, request.getReceiver()).ifPresent(s -> s.method_7353((class_2561)class_2561.method_43469((String)"msg.tprequest.cancelled", (Object[])new Object[]{request.getSummary(server)}).method_27692(class_124.field_1080), false));
            }
            src.method_9226(() -> class_2561.method_43469((String)"msg.tprequest.cancelled", (Object[])new Object[]{request.getSummary(server)}).method_27692(class_124.field_1054), false);
            return 1;
        }))).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPCANCEL, 0))).executes(CommandImpl::cancel)));
        cmds.put("trtpaccept", (LiteralCommandNode<class_2168>)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trtpaccept").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPACCEPT, 0))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            TeleportRequest request = Utilities.parseRequest(class_5242.method_27645((CommandContext)ctx, (String)"id"));
            class_3222 srcPlayer = src.method_44023();
            if (srcPlayer == null) {
                return 0;
            }
            if (!request.getReceiver().equals(srcPlayer.method_5667())) {
                src.method_9213((class_2561)class_2561.method_43469((String)"msg.tprequest.notfound", (Object[])new Object[]{""}));
                return 0;
            }
            MinecraftServer server = src.method_9211();
            if (!request.execute(server)) {
                src.method_9213((class_2561)class_2561.method_43471((String)"msg.tprequest.not_present"));
                return 0;
            }
            Utilities.getPlayer(server, request.getSender()).ifPresent(p -> {
                p.method_7353((class_2561)class_2561.method_43469((String)"msg.tprequest.accepted", (Object[])new Object[]{request.getSummary(server)}).method_27692(class_124.field_1060), false);
                ((ITeleportable)p).setTeleportCd(TeleportationRequest.getTpCd());
            });
            src.method_9226(() -> class_2561.method_43469((String)"msg.tprequest.accepted", (Object[])new Object[]{request.getSummary(server)}).method_27692(class_124.field_1060), false);
            ServerStorage.requests.remove(request);
            return 1;
        }))).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPACCEPT, 0))).executes(CommandImpl::accept)));
        cmds.put("trtpdeny", (LiteralCommandNode<class_2168>)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trtpdeny").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPDENY, 0))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            TeleportRequest request = Utilities.parseRequest(class_5242.method_27645((CommandContext)ctx, (String)"id"));
            class_3222 srcPlayer = src.method_44023();
            if (srcPlayer == null) {
                return 0;
            }
            if (!request.getReceiver().equals(srcPlayer.method_5667())) {
                src.method_9213((class_2561)class_2561.method_43469((String)"msg.tprequest.notfound", (Object[])new Object[]{""}));
                return 0;
            }
            if (!ServerStorage.requests.remove(request)) {
                src.method_9213((class_2561)class_2561.method_43471((String)"msg.tprequest.already_removed"));
                return 0;
            }
            MinecraftServer server = src.method_9211();
            Utilities.getPlayer(server, request.getSender()).ifPresent(s -> s.method_7353((class_2561)class_2561.method_43469((String)"msg.tprequest.denied", (Object[])new Object[]{request.getSummary(server)}).method_27692(class_124.field_1061), false));
            src.method_9226(() -> class_2561.method_43469((String)"msg.tprequest.denied", (Object[])new Object[]{request.getSummary(server)}).method_27692(class_124.field_1054), false);
            return 1;
        }))).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPDENY, 0))).executes(CommandImpl::deny)));
        cmds.put("trtpignore", (LiteralCommandNode<class_2168>)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trtpignore").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPIGNORE, 0))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            TeleportRequest request = Utilities.parseRequest(class_5242.method_27645((CommandContext)ctx, (String)"id"));
            class_3222 srcPlayer = src.method_44023();
            if (srcPlayer == null) {
                return 0;
            }
            if (!request.getReceiver().equals(srcPlayer.method_5667())) {
                src.method_9213((class_2561)class_2561.method_43469((String)"msg.tprequest.notfound", (Object[])new Object[]{""}));
                return 0;
            }
            request.setIgnored(true);
            MinecraftServer server = src.method_9211();
            src.method_9226(() -> class_2561.method_43469((String)"msg.tprequest.ignored", (Object[])new Object[]{request.getSummary(server)}).method_27692(class_124.field_1054), false);
            return 1;
        }))).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPIGNORE, 0))).executes(CommandImpl::ignore)));
        cmds.put("trtplist", (LiteralCommandNode<class_2168>)dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trtplist").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            MinecraftServer server = src.method_9211();
            class_3222 player = src.method_44023();
            if (player == null) {
                return 0;
            }
            ImmutableList<TeleportRequest> requests = ServerStorage.getRequestCopied();
            List<TeleportRequest> received = requests.stream().filter(r -> r.isReceiver(player)).toList();
            List<TeleportRequest> sent = requests.stream().filter(r -> r.isSender(player)).toList();
            boolean empty = true;
            if (!sent.isEmpty()) {
                empty = false;
                src.method_9226(() -> class_2561.method_43471((String)"category.tprequest.sent").method_27692(class_124.field_1075), false);
                sent.forEach(r -> {
                    class_5250 summary = r.getSummary(src.method_9211());
                    src.method_9226(() -> CommandInit.lambda$init$32((class_2561)summary), false);
                    src.method_9226(() -> CommandInit.lambda$init$33(r, (class_2561)summary), false);
                });
            }
            if (!received.isEmpty()) {
                empty = false;
                src.method_9226(() -> class_2561.method_43471((String)"category.tprequest.received").method_27692(class_124.field_1076), false);
                received.forEach(t -> {
                    class_5250 summary = t.getSummary(server);
                    String id = t.getId().toString();
                    boolean ignored = t.isIgnored();
                    src.method_9226(() -> summary.method_27694(s -> {
                        if (ignored) {
                            return s.method_10977(class_124.field_1080);
                        }
                        return s;
                    }).method_10852((class_2561)(t.isIgnored() ? class_2561.method_43471((String)"status.tprequest.ignored") : class_2561.method_43473())), false);
                    src.method_9226(() -> class_2561.method_43469((String)"msg.tprequest.respond.format", (Object[])new Object[]{class_2561.method_43471((String)"selection.tprequest.accept").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpaccept " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.accept.info", (Object[])new Object[]{summary})))), class_2561.method_43471((String)"selection.tprequest.deny").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpdeny " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.deny.info", (Object[])new Object[]{summary})))), ignored ? class_2561.method_43473() : class_2561.method_43471((String)"selection.tprequest.ignore").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpignore " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.ignore.info", (Object[])new Object[]{summary}))))}), false);
                });
            }
            if (empty) {
                src.method_9213((class_2561)class_2561.method_43471((String)"msg.tprequest.no_pending"));
            }
            return 1;
        })).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_TPLIST, 0))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tprequest").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            for (String e : cmds.keySet()) {
                src.method_9226(() -> class_2561.method_43471((String)("desc.tprequest." + e)).method_27692(class_124.field_1060), false);
                List<String> alias = TeleportationRequest.getAlternativesFor(e);
                if (!alias.isEmpty()) continue;
                src.method_9226(() -> class_2561.method_43471((String)"desc.tprequest.alias").method_27692(class_124.field_1054), false);
                alias.forEach(a -> src.method_9226(() -> class_2561.method_43470((String)("/" + a)).method_27692(class_124.field_1054), false));
            }
            return 1;
        })).requires(p -> Utilities.checkPerm(p, PermNode.COMMON_HELP, 0)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            boolean success = TeleportationRequest.reload(src.method_9211());
            src.method_9226(() -> class_2561.method_43471((String)("msg.tprequest.reload." + (success ? "success" : "failure").formatted(success ? class_124.field_1060 : class_124.field_1061))), false);
            return success ? 1 : 0;
        })).requires(p -> Utilities.checkPerm(p, PermNode.ADMIN_RELOAD, p.method_9211().method_3798())))).requires(p -> true));
        for (Map.Entry<String, LiteralCommandNode<class_2168>> e : cmds.entrySet()) {
            LiteralCommandNode<class_2168> p2 = e.getValue();
            TeleportationRequest.getAlternativesFor(e.getKey()).forEach(a -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)a).redirect((CommandNode)p2)).executes(p2.getCommand())).requires(p2.getRequirement())));
        }
    }

    private static /* synthetic */ class_2561 lambda$init$33(TeleportRequest r, class_2561 summary) {
        return class_2561.method_43471((String)"selection.tprequest.cancel").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpcancel " + r.getId().toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.cancel.info", (Object[])new Object[]{summary}))));
    }

    private static /* synthetic */ class_2561 lambda$init$32(class_2561 summary) {
        return summary;
    }

    private static /* synthetic */ class_2561 lambda$init$7(String id, class_2561 summary) {
        return class_2561.method_43471((String)"selection.tprequest.cancel").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpcancel " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.cancel.info", (Object[])new Object[]{summary}))));
    }

    private static /* synthetic */ class_2561 lambda$init$2(String id, class_2561 summary) {
        return class_2561.method_43471((String)"selection.tprequest.cancel").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/trtpcancel " + id)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"selection.tprequest.cancel.info", (Object[])new Object[]{summary}))));
    }
}

