/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.tprequest;

import committee.nova.tprequest.api.ITeleportable;
import committee.nova.tprequest.callback.TeleportationCallback;
import committee.nova.tprequest.cfg.TprConfig;
import committee.nova.tprequest.command.init.CommandInit;
import committee.nova.tprequest.storage.ServerStorage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.YamlConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class TeleportationRequest
implements ModInitializer {
    public static final String MODID = "tprequest";
    private static TprConfig cfg;

    public void onInitialize() {
        AutoConfig.register(TprConfig.class, YamlConfigSerializer::new);
        cfg = (TprConfig)AutoConfig.getConfigHolder(TprConfig.class).getConfig();
        ServerTickEvents.END_SERVER_TICK.register(ServerStorage::tick);
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> ServerStorage.requests.clear());
        CommandRegistrationCallback.EVENT.register(CommandInit::init);
        TeleportationCallback.EVENT.register((sender, receiver, tpType, formerWorld, formerPos) -> TeleportationRequest.getNotificationSound().ifPresent(r -> sender.method_17356(r, class_3419.field_15248, 1.0f, 1.0f)));
    }

    public static int getTpCd() {
        return TeleportationRequest.getActualTick(TeleportationRequest.cfg.tpCd);
    }

    public static int getExpirationTime() {
        return TeleportationRequest.getActualTick(TeleportationRequest.cfg.expirationTime);
    }

    private static int getActualTick(double t) {
        return (int)(t * 20.0);
    }

    public static List<String> getAlternativesFor(String cmd) {
        return switch (cmd) {
            case "trtpa" -> TeleportationRequest.cfg.saTpa;
            case "trtpahere" -> TeleportationRequest.cfg.saTpahere;
            case "trtpaccept" -> TeleportationRequest.cfg.saTpaccept;
            case "trtpcancel" -> TeleportationRequest.cfg.saTpcancel;
            case "trtpdeny" -> TeleportationRequest.cfg.saTpdeny;
            case "trtpignore" -> TeleportationRequest.cfg.saTpignore;
            case "trtplist" -> TeleportationRequest.cfg.saTplist;
            default -> Collections.emptyList();
        };
    }

    public static Optional<class_3414> getNotificationSound() {
        try {
            return Optional.ofNullable((class_3414)class_7923.field_41172.method_10223(new class_2960(TeleportationRequest.cfg.notificationSound)));
        }
        catch (class_151 ignored) {
            return Optional.empty();
        }
    }

    public static boolean reload(MinecraftServer server) {
        boolean reloaded = AutoConfig.getConfigHolder(TprConfig.class).load();
        cfg = (TprConfig)AutoConfig.getConfigHolder(TprConfig.class).getConfig();
        TeleportationRequest.postReload(server);
        return reloaded;
    }

    private static void postReload(MinecraftServer server) {
        int newExpiration = TeleportationRequest.getExpirationTime();
        ServerStorage.requests.forEach(r -> {
            if (newExpiration < r.getExpirationTime()) {
                r.setExpirationTime(newExpiration);
            }
        });
        int newCd = TeleportationRequest.getTpCd();
        server.method_3760().method_14571().forEach(p -> {
            ITeleportable t = (ITeleportable)p;
            if (t.getTeleportCd() > newCd) {
                t.setTeleportCd(newCd);
            }
        });
    }
}

